<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('S.N.'); ?></th>
                                    <th><?php echo app('translator')->get('Logo'); ?></th>
                                    <th><?php echo app('translator')->get('Stock'); ?></th>
                                    <th><?php echo app('translator')->get('Price'); ?></th>
                                    <th><?php echo app('translator')->get('Change'); ?></th>
                                    <th><?php echo app('translator')->get('Market Cap'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $stakings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $staking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($stakings->firstItem() + $loop->index); ?></td>
                                        <td>
                                            <img src="<?php echo e(getImage(getFilePath('stock').'/'.$staking->logo)); ?>" alt="logo" style="width:40px;">
                                        </td>
                                        <td><strong><?php echo e($staking->symbol); ?></strong></td>
                                        <td><?php echo e($staking->price); ?></td>
                                        <td class="<?php echo e(str_contains($staking->pct_change, '+') ? 'text--success' : 'text--danger'); ?>">
                                            <?php echo e($staking->pct_change); ?>

                                        </td>
                                        <td><?php echo e($staking->market_cap); ?></td>
                                        <td><?php echo $staking->statusBadge; ?></td>
                                        <td>
                                            <div class="button--group">
                                                <button 
                                                    data-id="<?php echo e($staking->id); ?>" 
                                                    data-symbol="<?php echo e($staking->symbol); ?>" 
                                                    data-price="<?php echo e($staking->price); ?>"
                                                    data-pct_change="<?php echo e($staking->pct_change); ?>"
                                                    data-volume="<?php echo e($staking->volume); ?>"
                                                    data-market_cap="<?php echo e($staking->market_cap); ?>"
                                                    data-pe_ratio="<?php echo e($staking->pe_ratio); ?>"
                                                    data-dividend_yield="<?php echo e($staking->dividend_yield); ?>"
                                                    data-sector="<?php echo e($staking->sector); ?>"
                                                    class="btn btn-outline--primary editBtn btn-sm"><i class="las la-pen"></i><?php echo app('translator')->get('Edit'); ?></button>
                                                
                                                <?php if($staking->status): ?>
                                                    <button class="btn btn-sm btn-outline--danger confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure to disable this stock?'); ?>" data-action="<?php echo e(route('admin.staking.status', $staking->id)); ?>"><i class="las la-eye-slash"></i><?php echo app('translator')->get('Disable'); ?></button>
                                                <?php else: ?>
                                                    <button class="btn btn-sm btn-outline--success confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure to enable this stock?'); ?>" data-action="<?php echo e(route('admin.staking.status', $staking->id)); ?>"><i class="las la-eye"></i><?php echo app('translator')->get('Enable'); ?></button>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($stakings->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($stakings)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="stakingModal">
        <div class="modal-dialog modal-lg"> 
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"></h4>
                    <button type="button" class="close" data-bs-dismiss="modal"><span><i class="las la-times"></i></span></button>
                </div>
                <form method="post" enctype="multipart/form-data"> 
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Stock Symbol'); ?></label>
                                    <input type="text" class="form-control" name="symbol" placeholder="e.g. NVDA" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Current Price'); ?></label>
                                    <input type="number" step="any" class="form-control" name="price" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Percentage Change'); ?></label>
                                    <input type="text" class="form-control" name="pct_change" placeholder="+1.02%">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Market Cap'); ?></label>
                                    <input type="text" class="form-control" name="market_cap" placeholder="$4.68T">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Volume'); ?></label>
                                    <input type="text" class="form-control" name="volume">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('P/E Ratio'); ?></label>
                                    <input type="number" step="any" class="form-control" name="pe_ratio">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Sector'); ?></label>
                                    <input type="text" class="form-control" name="sector">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Stock Logo'); ?></label>
                                    <input type="file" class="form-control" name="logo" accept=".png, .jpg, .jpeg">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <button class="btn btn-outline--primary btn-sm addBtn"><i class="las la-plus"></i> <?php echo app('translator')->get('Add New Stock'); ?></button>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            let modal = $('#stakingModal');
            let action = `<?php echo e(route('admin.staking.save')); ?>`;

            $('.addBtn').on('click', function() {
                modal.find('.modal-title').text(`<?php echo app('translator')->get('Add New Stock'); ?>`);
                modal.find('form').trigger('reset'); // Clear all inputs
                modal.find('form').attr('action', action);
                modal.modal('show');
            });

            $('.editBtn').on('click', function() {
                let data = $(this).data();
                modal.find('.modal-title').text(`<?php echo app('translator')->get('Update Stock'); ?>: ` + data.symbol);
                
                // Map data attributes to input names
                modal.find('[name=symbol]').val(data.symbol);
                modal.find('[name=price]').val(data.price);
                modal.find('[name=pct_change]').val(data.pct_change);
                modal.find('[name=market_cap]').val(data.market_cap);
                modal.find('[name=volume]').val(data.volume);
                modal.find('[name=pe_ratio]').val(data.pe_ratio);
                modal.find('[name=sector]').val(data.sector);
                
                modal.find('form').attr('action', `${action}/${data.id}`);
                modal.modal('show');
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/admin/staking/list.blade.php ENDPATH**/ ?>