
<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">


            <div class="show-filter mb-3 text-end">
                <button type="button" class="btn btn-outline--primary showFilterBtn btn-sm"><i class="las la-filter"></i> <?php echo app('translator')->get('Filter'); ?></button>
            </div>
            <div class="card responsive-filter-card mb-4">
                <div class="card-body">
                    <form>
                        <div class="d-flex flex-wrap gap-4">
                            <div class="flex-grow-1">
                                <label><?php echo app('translator')->get('Search'); ?></label>
                                <input type="search" name="search" value="<?php echo e(request()->search); ?>" class="form-control" placeholder="Username">
                            </div>
                            <div class="flex-grow-1">
                                <label><?php echo app('translator')->get('Status'); ?></label>
                                <select name="status" class="select2" data-minimum-results-for-search="-1">
                                    <option value=""><?php echo app('translator')->get('All Status'); ?></option>
                                    <option value="1" <?php if(request('status') == 1): echo 'selected'; endif; ?>><?php echo app('translator')->get('Running'); ?></option>
                                    <option value="2" <?php if(request('status') == 2): echo 'selected'; endif; ?>><?php echo app('translator')->get('Completed'); ?></option>
                                </select>
                            </div>
                            <div class="flex-grow-1">
                                <label><?php echo app('translator')->get('Plan'); ?></label>
                                <select name="staking_id" class="select2" data-minimum-results-for-search="-1">
                                    <option value=""><?php echo app('translator')->get('All Plan'); ?></option>
                                    <?php $__currentLoopData = $investPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investPlan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($investPlan->id); ?>" <?php if(request('staking_id') == $investPlan->id): echo 'selected'; endif; ?>><?php echo e($investPlan->days); ?> <?php echo app('translator')->get('Days'); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="flex-grow-1">
                                <label><?php echo app('translator')->get('Date'); ?></label>
                                <input name="date" type="search" class="datepicker-here form-control bg--white pe-2 date-range" placeholder="<?php echo app('translator')->get('Start Date - End Date'); ?>" autocomplete="off" value="<?php echo e(request()->date); ?>">
                            </div>
                            <div class="flex-grow-1 align-self-end">
                                <button class="btn btn--primary w-100 h-45"><i class="fas fa-filter"></i> <?php echo app('translator')->get('Filter'); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>








            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('User'); ?></th>
                                    <th><?php echo app('translator')->get('Amount'); ?></th>
                                    <th><?php echo app('translator')->get('Interest'); ?></th>
                                    <th><?php echo app('translator')->get('Total Return'); ?></th>
                                    <th><?php echo app('translator')->get('Invest Date'); ?></th>
                                    <th><?php echo app('translator')->get('Return Date'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $stakingInvests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stakingInvest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <span class="fw-bold"><?php echo e($stakingInvest->user->fullname); ?></span>
                                            <br>
                                            <span class="small">
                                                <a href="<?php echo e(route('admin.users.detail', $stakingInvest->user->id)); ?>"><span>@</span><?php echo e($stakingInvest->user->username); ?></a>
                                            </span>
                                        </td>
                                        <td><?php echo e(showAmount($stakingInvest->invest_amount)); ?></td>
                                        <td><?php echo e(showAmount($stakingInvest->interest)); ?></td>
                                        <td><?php echo e(showAmount($stakingInvest->invest_amount + $stakingInvest->interest)); ?></td>
                                        <td><?php echo e(showDateTime($stakingInvest->created_at)); ?></td>
                                        <td><?php echo e(showDateTime($stakingInvest->end_at)); ?></td>
                                        <td>
                                            <?php if($stakingInvest->status == 1): ?>
                                                <span class="badge badge--success"><?php echo app('translator')->get('Running'); ?></span>
                                            <?php else: ?>
                                                <span class="badge badge--primary"><?php echo app('translator')->get('Completed'); ?></span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <?php if($stakingInvests->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($stakingInvests)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/daterangepicker.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/admin/css/daterangepicker.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict"

            const datePicker = $('.date-range').daterangepicker({
                autoUpdateInput: false,
                locale: {
                    cancelLabel: 'Clear'
                },
                showDropdowns: true,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 15 Days': [moment().subtract(14, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(30, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                    'Last 6 Months': [moment().subtract(6, 'months').startOf('month'), moment().endOf('month')],
                    'This Year': [moment().startOf('year'), moment().endOf('year')],
                },
                maxDate: moment()
            });
            const changeDatePickerText = (event, startDate, endDate) => {
                $(event.target).val(startDate.format('MMMM DD, YYYY') + ' - ' + endDate.format('MMMM DD, YYYY'));
            }


            $('.date-range').on('apply.daterangepicker', (event, picker) => changeDatePickerText(event, picker.startDate, picker.endDate));


            if ($('.date-range').val()) {
                let dateRange = $('.date-range').val().split(' - ');
                $('.date-range').data('daterangepicker').setStartDate(new Date(dateRange[0]));
                $('.date-range').data('daterangepicker').setEndDate(new Date(dateRange[1]));
            }

        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/admin/staking/invest.blade.php ENDPATH**/ ?>