<?php $__env->startSection('content'); ?>
<div class="px-4 mx-auto py-3">

    
    <div class="flex flex-col md:flex-row md:items-center justify-between gap-6 mb-12">
        <div class="flex items-center gap-5">
            <div class="relative group">
                <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-2xl blur opacity-25"></div>
                <div class="relative w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-2xl">
                    <i data-lucide="send" class="w-7 h-7 text-emerald-400"></i>
                </div>
            </div>
            <div>
                <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase"><?php echo app('translator')->get('Balance Transfer'); ?></h2>
                <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1"><?php echo app('translator')->get('Internal Peer-to-Peer Liquidity'); ?></p>
            </div>
        </div>

        <a href="<?php echo e(route('user.transactions')); ?>" class="group relative px-6 py-3 bg-slate-100 dark:bg-white/5 rounded-xl transition-all hover:bg-slate-900 dark:hover:bg-white overflow-hidden">
            <span class="relative z-10 text-[10px] font-black uppercase tracking-widest text-slate-600 dark:text-slate-400 group-hover:text-white dark:group-hover:text-slate-900"><?php echo app('translator')->get('Transfer Logs'); ?></span>
        </a>
    </div>

    <form method="post" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="grid grid-cols-12 gap-8">
            
            
            <div class="col-span-12 lg:col-span-7 space-y-8">
                <div class="flex items-center gap-4 mb-4">
                    <span class="text-[11px] font-black text-slate-900 dark:text-white uppercase tracking-[0.3em]">01. <?php echo app('translator')->get('Recipient Details'); ?></span>
                    <div class="h-px flex-1 bg-slate-200 dark:bg-white/10"></div>
                </div>

                <div class="space-y-6">
                    
                    <div class="group">
                        <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest mb-3 block"><?php echo app('translator')->get('Select Source Wallet'); ?></label>
                        <div class="relative">
                            <select class="w-full bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-2xl py-5 px-6 text-sm font-bold text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none appearance-none cursor-pointer" name="wallet">
                                <option value=""><?php echo app('translator')->get('Choose account...'); ?></option>
                                <option value="deposit_wallet"><?php echo app('translator')->get('Deposit Wallet'); ?> — <?php echo e(showAmount($user->deposit_wallet)); ?></option>
                                <option value="interest_wallet"><?php echo app('translator')->get('Interest Wallet'); ?> — <?php echo e(showAmount($user->interest_wallet)); ?></option>
                            </select>
                            <i data-lucide="chevron-down" class="absolute right-6 top-1/2 -translate-y-1/2 w-4 h-4 text-slate-400"></i>
                        </div>
                    </div>

                    
                    <div class="group">
                        <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest mb-3 block"><?php echo app('translator')->get('Recipient Username'); ?></label>
                        <div class="relative">
                            <input type="text" name="username" class="findUser w-full bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-2xl py-5 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-blue-500 transition-all outline-none" required placeholder="<?php echo app('translator')->get('Enter target username'); ?>">
                            <div class="status-icon absolute right-6 top-1/2 -translate-y-1/2"></div>
                        </div>
                        <code class="error-message text-[10px] font-bold text-rose-500 uppercase tracking-tight mt-2 block ml-2"></code>
                    </div>

                    <?php if(auth()->user()->ts): ?>
                    
                    <div class="p-6 rounded-2xl bg-rose-500/5 border border-rose-500/10 space-y-3">
                        <label class="text-[10px] font-black text-rose-500 uppercase tracking-widest flex items-center gap-2">
                            <i data-lucide="shield-check" class="w-3.5 h-3.5"></i> <?php echo app('translator')->get('Authenticator Code'); ?>
                        </label>
                        <input type="text" name="authenticator_code" class="w-full bg-transparent border-none p-0 text-lg font-black tracking-[0.4em] text-slate-900 dark:text-white focus:ring-0" required placeholder="000000">
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            
            <div class="col-span-12 lg:col-span-5">
                <div class="flex items-center gap-4 mb-4">
                    <span class="text-[11px] font-black text-slate-900 dark:text-white uppercase tracking-[0.3em]">02. <?php echo app('translator')->get('Transfer Spec'); ?></span>
                    <div class="h-px flex-1 bg-slate-200 dark:bg-white/10"></div>
                </div>

                <div class="relative">
                    <div class="absolute -inset-0.5 bg-gradient-to-b from-emerald-500/20 to-transparent rounded-[2rem] blur-sm"></div>
                    
                    <div class="relative bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2rem] p-8 shadow-2xl">
                        
                        <div class="mb-8">
                            <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest mb-3 block"><?php echo app('translator')->get('Transfer Amount'); ?></label>
                            <div class="relative group">
                                <div class="absolute left-5 top-1/2 -translate-y-1/2 text-slate-400 font-black"><?php echo e(gs('cur_sym')); ?></div>
                                <input type="number" step="any" name="amount" autocomplete="off" class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-5 pl-12 pr-6 text-xl font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-emerald-500 transition-all outline-none" placeholder="0.00">
                            </div>
                        </div>

                        <div class="space-y-4 pt-6 border-t border-slate-100 dark:border-white/5">
                            <div class="flex justify-between items-center">
                                <span class="text-[10px] font-bold text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Fixed Charge'); ?></span>
                                <span class="text-[11px] font-black text-slate-900 dark:text-white"><?php echo e(getAmount(gs('f_charge'))); ?> <?php echo e(gs('cur_text')); ?></span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="text-[10px] font-bold text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Percent Charge'); ?></span>
                                <span class="text-[11px] font-black text-rose-500"><?php echo e(getAmount(gs('p_charge'))); ?>%</span>
                            </div>
                            
                            <div class="calculation-display d-none py-3 px-4 bg-emerald-500/5 rounded-xl border border-emerald-500/10 mt-4">
                                <div class="flex justify-between items-center text-[10px] font-black">
                                    <span class="text-emerald-600 uppercase"><?php echo app('translator')->get('Total Deductible'); ?></span>
                                    <span class="text-emerald-600 calculation-text"></span>
                                </div>
                            </div>

                            <div class="pt-10">
                                <div class="flex justify-between items-end mb-6">
                                    <span class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em]"><?php echo app('translator')->get('Recipient Gets'); ?></span>
                                    <div class="text-right">
                                        <span class="text-3xl font-black text-slate-900 dark:text-white tracking-tighter"><?php echo e(gs('cur_sym')); ?><span class="final-amount">0.00</span></span>
                                    </div>
                                </div>

                                <button type="submit" class="group relative w-full h-16 bg-slate-900 dark:bg-white rounded-2xl overflow-hidden transition-all active:scale-95 shadow-xl">
                                    <div class="absolute inset-0 bg-gradient-to-r from-emerald-500 to-blue-500 opacity-0 group-hover:opacity-100 transition-opacity"></div>
                                    <span class="relative text-[11px] font-black text-white dark:text-slate-900 uppercase tracking-[0.3em] group-hover:text-white"><?php echo app('translator')->get('Initialize Transfer'); ?></span>
                                </button>
                                
                                <p class="text-[9px] text-center text-slate-400 mt-4 px-6 leading-relaxed uppercase font-black tracking-tight italic">
                                    <?php echo app('translator')->get('Funds are moved instantly across secure protocol nodes.'); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script src="https://unpkg.com/lucide@latest"></script>
<script>
    "use strict";
    (function ($) {
        lucide.createIcons();

        // Amount calculation
        $('input[name=amount]').on('input', function() {
            var amo = parseFloat($(this).val());
            var f_charge = parseFloat("<?php echo e(gs('f_charge')); ?>");
            var p_charge = parseFloat("<?php echo e(gs('p_charge')); ?>");
            
            if (amo > 0) {
                var totalCharge = f_charge + (amo * p_charge / 100);
                var totalDeduction = amo + totalCharge;
                
                $('.calculation-display').removeClass('d-none');
                $('.calculation-text').text(totalDeduction.toFixed(2) + ' <?php echo e(gs('cur_text')); ?>');
                $('.final-amount').text(amo.toFixed(2));
            } else {
                $('.calculation-display').addClass('d-none');
                $('.final-amount').text('0.00');
            }
        });

        // User lookup
        $('.findUser').on('focusout', function() {
            var value = $(this).val();
            var $icon = $('.status-icon');
            
            if(value) {
                $.post('<?php echo e(route('user.findUser')); ?>', {
                    username: value,
                    _token: '<?php echo e(csrf_token()); ?>'
                }, function(response) {
                    if (response.message) {
                        $('.error-message').text(response.message);
                        $icon.html('<i data-lucide="alert-circle" class="w-5 h-5 text-rose-500"></i>');
                    } else {
                        $('.error-message').text('');
                        $icon.html('<i data-lucide="check-circle-2" class="w-5 h-5 text-emerald-500"></i>');
                    }
                    lucide.createIcons();
                });
            } else {
                $icon.empty();
                $('.error-message').empty();
            }
        });

    })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/balance_transfer.blade.php ENDPATH**/ ?>